/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend.mixin;

import fionathemortal.betterbiomeblend.common.BlendCache;
import fionathemortal.betterbiomeblend.common.BlendChunk;
import fionathemortal.betterbiomeblend.common.ColorCaching;
import fionathemortal.betterbiomeblend.common.CustomColorResolverCompatibility;
import fionathemortal.betterbiomeblend.common.cache.BiomeCache;
import fionathemortal.betterbiomeblend.common.cache.ColorCache;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.function.Supplier;
import net.minecraft.class_1163;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2874;
import net.minecraft.class_3695;
import net.minecraft.class_4700;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_638.class})
public abstract class MixinClientWorld
extends class_1937 {
    @Shadow
    private final Object2ObjectArrayMap<class_6539, class_4700> field_21527 = new Object2ObjectArrayMap();
    @Unique
    public final BlendCache betterBiomeBlend$blendColorCache = new BlendCache(2048);
    @Unique
    public final ColorCache betterBiomeBlend$chunkColorCache = new ColorCache(512);
    @Unique
    public final BiomeCache betterBiomeBlend$chunkBiomeCache = new BiomeCache(32);
    @Unique
    private final ThreadLocal<BlendChunk> betterBiomeBlend$threadLocalWaterChunk = ThreadLocal.withInitial(() -> {
        BlendChunk chunk = new BlendChunk();
        chunk.acquire();
        return chunk;
    });
    @Unique
    private final ThreadLocal<BlendChunk> betterBiomeBlend$threadLocalGrassChunk = ThreadLocal.withInitial(() -> {
        BlendChunk chunk = new BlendChunk();
        chunk.acquire();
        return chunk;
    });
    @Unique
    private final ThreadLocal<BlendChunk> betterBiomeBlend$threadLocalFoliageChunk = ThreadLocal.withInitial(() -> {
        BlendChunk chunk = new BlendChunk();
        chunk.acquire();
        return chunk;
    });
    @Unique
    private final ThreadLocal<BlendChunk> betterBiomeBlend$threadLocalGenericChunk = ThreadLocal.withInitial(() -> {
        BlendChunk chunk = new BlendChunk();
        chunk.acquire();
        return chunk;
    });

    protected MixinClientWorld(class_5269 writableLevelData, class_5321<class_1937> resourceKey, class_6880<class_2874> holder, Supplier<class_3695> supplier, boolean bl, boolean bl2, long l, int i) {
        super(writableLevelData, resourceKey, holder, supplier, bl, bl2, l, i);
    }

    @Inject(method={"clearTintCaches"}, at={@At(value="HEAD")})
    public void onClearColorCaches(CallbackInfo ci) {
        this.betterBiomeBlend$blendColorCache.invalidateAll();
        this.betterBiomeBlend$chunkColorCache.invalidateAll();
        this.betterBiomeBlend$chunkBiomeCache.invalidateAll();
    }

    @Inject(method={"onChunkLoaded"}, at={@At(value="HEAD")})
    public void onOnChunkLoaded(class_1923 chunkPos, CallbackInfo ci) {
        int chunkX = chunkPos.field_9181;
        int chunkZ = chunkPos.field_9180;
        this.betterBiomeBlend$blendColorCache.invalidateChunk(chunkX, chunkZ);
        this.betterBiomeBlend$chunkColorCache.invalidateSmallNeighborhood(chunkX, chunkZ);
        this.betterBiomeBlend$chunkBiomeCache.invalidateSmallNeighborhood(chunkX, chunkZ);
    }

    @Overwrite
    public int method_23752(class_2338 blockPosIn, class_6539 colorResolverIn) {
        ThreadLocal<BlendChunk> threadLocalChunk;
        int colorType;
        if (colorResolverIn == class_1163.field_5665) {
            colorType = 0;
            threadLocalChunk = this.betterBiomeBlend$threadLocalGrassChunk;
        } else if (colorResolverIn == class_1163.field_5666) {
            colorType = 1;
            threadLocalChunk = this.betterBiomeBlend$threadLocalWaterChunk;
        } else if (colorResolverIn == class_1163.field_5664) {
            colorType = 2;
            threadLocalChunk = this.betterBiomeBlend$threadLocalFoliageChunk;
        } else {
            colorType = CustomColorResolverCompatibility.getColorType(colorResolverIn);
            threadLocalChunk = this.betterBiomeBlend$threadLocalGenericChunk;
        }
        int x = blockPosIn.method_10263();
        int y = blockPosIn.method_10264();
        int z = blockPosIn.method_10260();
        int chunkX = x >> 4;
        int chunkY = y >> 4;
        int chunkZ = z >> 4;
        BlendChunk chunk = ColorCaching.getThreadLocalChunk(threadLocalChunk, chunkX, chunkY, chunkZ, colorType);
        if (chunk == null) {
            chunk = ColorCaching.getBlendedColorChunk(this, colorResolverIn, colorType, chunkX, chunkY, chunkZ, this.betterBiomeBlend$blendColorCache, this.betterBiomeBlend$chunkColorCache, this.betterBiomeBlend$chunkBiomeCache);
            ColorCaching.setThreadLocalChunk(threadLocalChunk, chunk, this.betterBiomeBlend$blendColorCache);
        }
        int result = chunk.getColor(x, y, z);
        return result;
    }
}

